<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

namespace StemBase\Modules\Shortcodes\Shortcode;

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

use StemBase\Modules\Shortcodes\Shortcode\ShortcodeBase;

class Columns extends ShortcodeBase {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $name = "columns";
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $version = "1.0";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $help = "";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_usage = "[columns][column xl=\"6\"]....[/colum]...[/columns]\n[columns gutter=\"10\"][column xl=\"6\"]....[/colum]...[/columns]";

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_attributes = array(
		array(
			"name"		=> "gutter",
			"hint"		=> "0,10,20,30,40,50 default: template default"
		),

		array(
			"name"		=> "same_height",
			"hint"		=> "yes|no default: no. Makes all colums same height independent of the content inside"
		),

		array(
			"name"		=> "masonry",
			"hint"		=> "yes|no default: no. Makes all columns fit the needed space"
		),

		array(
			"name"		=> "class",
			"hint"		=> "custom css class to the wrapping element for future customization"
		)	
	);


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($data) {
		$this->loadTemplate();

		$css = array();

		if ($data["vars"]["class"]) { $css[] = $data["vars"]["class"]; }

		if ($data["vars"]["bg"]) {
			$css[] = "columns-with-background";
		}		

		if ($data["vars"]["masonry"] == "yes") {
			$css[] = "isotope-container";
		}		

		return array(
			"content"	=> $this->tpl->blockReplace(
					"Main",
					array(
						"css"		=> implode(" " , $css),
						"content"	=> $data["vars"]["content"],
						"before"	=> $data["before"],
						"after"		=> $data["after"],
					),
					$this->getBackground($data["vars"]["bg"])
				),
			"before"	=> "",
			"after"		=> "",

		);
	}
	
	
}